import React from "react";
import ReactDOM from "react-dom/client";
import { BrowserRouter, Routes, Route } from "react-router-dom";
import { AuthProvider } from "./AuthContext";
import LoginPage from "./pages/LoginPage";
import TrainingListPage from "./pages/TrainingListPage";
import TrainingFormPage from "./pages/TrainingFormPage";
import ProtectedRoute from "./ProtectedRoute";
import TrainingDetailPage from "./pages/TrainingDetailPage";

import "./index.css";

ReactDOM.createRoot(document.getElementById("root")).render(
  <React.StrictMode>
    <BrowserRouter>
      <AuthProvider>
        <Routes>
          <Route path="/login" element={<LoginPage />} />

          <Route
            path="/"
            element={
              <ProtectedRoute>
                <TrainingListPage />
              </ProtectedRoute>
            }
          />

          <Route
            path="/training/new"
            element={
              <ProtectedRoute roles={["user", "hrd", "admin"]}>
                <TrainingFormPage />
              </ProtectedRoute>
            }
          />

          <Route
            path="/training/:id"
            element={
              <ProtectedRoute>
               <TrainingDetailPage />
              </ProtectedRoute>
            }
          />

          {/* kalau nanti mau halaman khusus HRD/Admin, tinggal tambah route lain */}
        </Routes>
      </AuthProvider>
    </BrowserRouter>
  </React.StrictMode>
);